﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Numerics;

namespace Fei.BaseLib {
    /// <summary>
    /// Slouží k převodu čísla mezi různými číselnými soustavami.
    /// </summary>
    public class MathConvert {
        /// <summary>
        /// Převede číslo z binární do desítkové soustavy.
        /// </summary>
        /// <param name="value">Číslo v binární soustavě.</param>
        /// <returns>Číslo v desítkové soustavě nebo <c>null</c>.</returns>
        public static int? FromBinary(string value) {
            int cislice, cislo = 0;
            if (value.Length < 1) {
                return null;
            }
            bool jeZaporne = value[0] == '-';
            if (jeZaporne) {
                value = value.Remove(0, 1);
            }
            for (int i = 0; i < value.Length; i++) {
                if (value[i] != '1' && value[i] != '0') {
                    return null;
                }
                cislice = value[i] == '0' ? 0 : 1;
                //cislo += cislice * (int)Math.Pow(2, value.Length - i - 1);
                cislo += cislice * (1 << (value.Length - i - 1));
            }
            return jeZaporne ? -cislo : cislo;
        }

        /// <summary>
        /// Převede číslo do binární z desítkové soustavy.
        /// </summary>
        /// <param name="value">Číslo v desítkové soustavě.</param>
        /// <returns>Číslo v binární soustavě.</returns>
        public static string ToBinary(int value) {
            StringBuilder sb = new StringBuilder();
            bool jeZaporne = value < 0;
            value = Math.Abs(value);
            do {
                int zbytek = value % 2;
                //sb.Append(zbytek.ToString(),0,zbytek.ToString().Length);
                sb.Insert(0, zbytek);
                value = value / 2;
            } while (value > 0);
            if (jeZaporne) {
                sb.Insert(0, '-');
            }
            return sb.ToString();
        }
        /// <summary>
        /// 
        /// </summary>
        /// <param name="value"></param>
        /// <returns></returns>
        public static BigInteger ToBinaryBigInteger(int value) {
            StringBuilder sb = new StringBuilder();
            bool jeZaporne = value < 0;
            value = Math.Abs(value);
            BigInteger nasobitel = 1;
            BigInteger cislo = 0;
            do {
                int zbytek = value % 2;
                cislo += zbytek * nasobitel;
                nasobitel *= 10;
                value = value / 2;
            } while (value > 0);
            if (jeZaporne) {
                sb.Insert(0, '-');
            }
            return cislo;
        }

        public static int? FromRoman(string value) {
            int pocetOpakovani = 0;
            int predchoziCislice = 0;
            int maxCislice = 0;
            int cislice, cislo = 0, dalsiCislice;
            for (int i = 0; i < value.Length; i++) {
                cislice = fromRomanDigit(value[i]);

                if (cislice == 0) {
                    return null;
                }

                if (cislice == predchoziCislice) {
                    if (cislice == 5 || cislice == 50 || cislice == 500) {
                        return null;
                    }
                    pocetOpakovani++;
                    if (pocetOpakovani > 2) {
                        return null;
                    }
                } else {
                    pocetOpakovani = 0;
                }
                predchoziCislice = cislice;

                if (i < value.Length - 1) {
                    dalsiCislice = fromRomanDigit(value[i + 1]);
                    if (cislice < dalsiCislice) {
                        cislice = dalsiCislice - cislice;

                        if (pocetOpakovani > 0) { return null; }
                        maxCislice = findMaxDigitBefore(dalsiCislice);
                        if (maxCislice != cislice) {
                            return null;
                        }
                        i++;
                        cislice = dalsiCislice - cislice;
                    }
                }

                cislo += cislice;
            }
            return cislo;
        }

        /// <summary>
        /// Převede číslo z desítkové do římské soustavy.
        /// </summary>
        /// <param name="value">Číslo v desítkové soustavě.</param>
        /// <returns>Číslo v binární soustavě.</returns>
        public static string ToRoman(int value) {
            bool delitDvema = false;
            StringBuilder sb = new StringBuilder();
            int pocetCislic, maxCislice;
            for (int i = 1000; i >= 1; i /= delitDvema ? 2 : 5) {
                delitDvema = !delitDvema;
                pocetCislic = value / i;
                if (pocetCislic > 0) {
                    sb.Append(toRomanDidit(i), pocetCislic);
                }
                //value -= i*pocetCislic;
                value %= i;
                if (value == 0) {
                    return sb.ToString();
                }
                maxCislice = findMaxDigitBefore(i);
                if ((i - value) <= maxCislice) {
                    sb.Append(toRomanDidit(maxCislice));
                    sb.Append(toRomanDidit(i));
                    value -= i - maxCislice;
                }
            }
            return null;
        }

        private static char toRomanDidit(int value) {
            switch (value) {
                case 1: return 'I';
                case 5: return 'V';
                case 10: return 'X';
                case 50: return 'L';
                case 100: return 'C';
                case 500: return 'D';
                case 1000: return 'M';
                default: return '_';
            }
        }

        private static int fromRomanDigit(char value) {
            switch (value) {
                case 'I': return 1;
                case 'V': return 5;
                case 'X': return 10;
                case 'L': return 50;
                case 'C': return 100;
                case 'D': return 500;
                case 'M': return 1000;
                default: return 0;
            }
        }
        private static int findMaxDigitBefore(int value) {
            for (int i = 100; i > 1; i /= 10) {
                if (i < value) {
                    return i;
                }
            }
            return -1;
        }
    }
}
