﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Fei.BaseLib
{
   /// <summary>
   /// Třída obsahující metody pro matematické operace.
   /// </summary>
   public class Matematika
   {
      /// <summary>
      /// Vypočte zadaný kořen kvadratické rovnice.
      /// </summary>
      /// <param name="a">Koeficient a.</param>
      /// <param name="b">Koeficient b.</param>
      /// <param name="c">Koeficient c.</param>
      /// <param name="prvniKoren">Je-li <c>true</c>, vypočte se první kořen, 
      /// jinak se vypočte druhý kořen.</param>
      /// <returns>Je-li parametr <paramref name="prvniKoren"/> roven <c>true</c>, vrací 
      /// hodnotu prvního kořene, jinak hodnotu druhého kořene.</returns>
      public static double KorenKvadrRovnice(double a, double b, double c, bool prvniKoren)
      {
         if (a == 0) {
            return -c / b;
         }
         else {
            double d = b * b - 4 * a * c;
            if (prvniKoren) {
               return (-b + Math.Sqrt(d)) / (2 * a);
            }
            else {
               return (-b - Math.Sqrt(d)) / (2 * a);
            }
         }
      }
   }
}
