﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Fei.BaseLib
{
   /// <summary>
   /// Obsahuje metody pro čtení hodnot z klávesnice.
   /// </summary>
   public class Cteni
   {
      /// <summary>
      /// Vypíše zadaný text na obrazovku s doplněním dvojtečky a mezery 
      /// a načte číslo typu <see cref="double"/>.
      /// </summary>
      /// <param name="vyzva">Text, který se vypíše na obrazovku. 
      /// Nesmí na konci obsahovat dvojtečku a mezeru.</param>
      /// <returns>Načtené reálné číslo.</returns>
      /// <exception cref="FormatException">Načtené číslo není ve správném formátu.</exception>
      /// <exception cref="OverflowException">Načtené číslo je menší než 
      /// <see cref="double.MinValue"/> nebo větší než <see cref="double.MaxValue"/>.
      /// </exception>
      public static double NactiDouble(string vyzva)
      {
         Console.Write(vyzva + ": ");
         return double.Parse(Console.ReadLine());
      }
      /// <summary>
      /// Vypíše zadaný text na obrazovku s doplněním dvojtečky a mezery 
      /// a načte číslo typu <see cref="int"/>.
      /// </summary>
      /// <param name="vyzva">Text, který se vypíše na obrazovku. 
      /// Nesmí na konci obsahovat dvojtečku a mezeru.</param>
      /// <returns>Načtené cele číslo.</returns>
      /// <exception cref="FormatException">Načtené číslo není ve správném formátu.</exception>
      /// <exception cref="OverflowException">Načtené číslo je menší než 
      /// <see cref="int.MinValue"/> nebo větší než <see cref="int.MaxValue"/>.
      /// </exception>
      public static int NactiInt(string vyzva)
      {
         Console.Write(vyzva + ": ");
         return int.Parse(Console.ReadLine());
      }
      /// <summary>
      /// Vypíše zadaný text na obrazovku s doplněním dvojtečky a mezery 
      /// a načte řetězec znaků typu <see cref="string"/>.
      /// </summary>
      /// <param name="vyzva">Text, který se vypíše na obrazovku. 
      /// Nesmí na konci obsahovat dvojtečku a mezeru.</param>
      /// <returns>Načtený řetězec znaků.</returns>
      public static string NactiString(string vyzva)
      {
         Console.Write(vyzva + ": ");
         return Console.ReadLine();
      }
   }
}
