unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ExtCtrls, StdCtrls;

type
  TForm1 = class(TForm)
    pnl_menu: TPanel;
    PaintBox1: TPaintBox;
    btn_konec: TButton;
    btn_konzad: TButton;
    btn_hranice: TPanel;
    cd_hranice: TColorDialog;
    cd_pozadi: TColorDialog;
    shp_hranice: TShape;
    shp_pozadi: TShape;
    btn_pozadi: TButton;
    btn_xor: TButton;
    btn_clear: TButton;
    procedure FormCreate(Sender: TObject);
    procedure PaintBox1MouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure btn_konecClick(Sender: TObject);
    procedure btn_konzadClick(Sender: TObject);
    procedure btn_hraniceClick(Sender: TObject);
    procedure btn_pozadiClick(Sender: TObject);
    procedure btn_xorClick(Sender: TObject);
    procedure shp_hraniceMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure shp_pozadiMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure btn_clearClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;
  kliknuti:integer;
  vrcholy:array[1..10] of TPoint;
  konec:boolean;

implementation

{$R *.dfm}

procedure TForm1.FormCreate(Sender: TObject);
begin
  kliknuti:=0;
  konec:=false;
  shp_hranice.Brush.Color:=clRed;
  shp_pozadi.Brush.Color:=clblue;
end;

procedure TForm1.PaintBox1MouseDown(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
      PaintBox1.Canvas.Pen.Color:=shp_hranice.Brush.Color;
      PaintBox1.Canvas.Brush.Style:=bsClear;
      PaintBox1.Canvas.Pen.Style:=psSolid;
  if Button = mbLeft then
  begin
  if kliknuti = 10 then
    begin
      btn_konzad.Click;
    end
  else
    begin
      inc(kliknuti);
      vrcholy[kliknuti].X:=X;
      vrcholy[kliknuti].Y:=y;
//      PaintBox1.Canvas.Ellipse(X-3,Y-3,X+3,Y+3);
      if kliknuti>1 then
        begin
          PaintBox1.Canvas.MoveTo(X,Y);
          PaintBox1.Canvas.LineTo(vrcholy[kliknuti-1].X,vrcholy[kliknuti-1].Y);
        end;
    end;
  end;
end;

procedure TForm1.btn_konecClick(Sender: TObject);
begin
  Application.Terminate;
end;

procedure TForm1.btn_konzadClick(Sender: TObject);
begin
  PaintBox1.Canvas.MoveTo(vrcholy[1].X,vrcholy[1].Y);
  PaintBox1.Canvas.LineTo(vrcholy[kliknuti].X,vrcholy[kliknuti].Y);
  konec:=true;
end;

procedure TForm1.btn_hraniceClick(Sender: TObject);
begin
  if cd_hranice.Execute then
    shp_hranice.Brush.Color:=cd_hranice.Color;
end;

procedure TForm1.btn_pozadiClick(Sender: TObject);
begin
  if cd_pozadi.Execute then
    shp_pozadi.Brush.Color:=cd_pozadi.Color;
end;

procedure TForm1.btn_xorClick(Sender: TObject);
var i,j, pom:integer;
    ph,ld:TPoint;
    suda:boolean;
begin
  if konec=false then btn_konzad.Click;
  ph:=vrcholy[1];
  ld:=vrcholy[1];
  for i:=1 to kliknuti do
    begin
      if ph.X > vrcholy[i].X then ph.X:=vrcholy[i].X;
      if ph.Y > vrcholy[i].Y then ph.Y:=vrcholy[i].Y;
      if ld.X < vrcholy[i].X then ld.X:=vrcholy[i].X;
      if ld.Y < vrcholy[i].Y then ld.Y:=vrcholy[i].Y;
    end;

  for i:=ph.X to ld.X do
    begin
      suda:=true;
      for j:=0 to PaintBox1.Width do
        begin
          if PaintBox1.Canvas.Pixels[j,i] = shp_hranice.Brush.Color then
            begin
              if suda = true then
                begin
                  suda := false;
                  for pom:=j to PaintBox1.Width do
                    begin
                      PaintBox1.Canvas.Pen.Mode:=pmCopy;
                      PaintBox1.Canvas.Pixels[j,i]:=shp_pozadi.Brush.Color;
                    end;
                end
              else
                begin
                  suda:= true;
                  for pom:=j to PaintBox1.Width do
                    begin
                      PaintBox1.Canvas.Pen.Mode:=pmXor;
                      PaintBox1.Canvas.Pixels[j,i]:=shp_pozadi.Brush.Color;
                    end;
                end;
            end;
      if suda=false then
        begin
              PaintBox1.Canvas.Pen.Mode:=pmXor;
              PaintBox1.Canvas.Pixels[j,i]:=shp_pozadi.Brush.Color;
        end;
      end;
    end;
  PaintBox1.Canvas.Pen.Mode:=pmCopy;
end;

procedure TForm1.shp_hraniceMouseDown(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
  if cd_hranice.Execute then
    shp_hranice.Brush.Color:=cd_hranice.Color;
end;

procedure TForm1.shp_pozadiMouseDown(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
  if cd_pozadi.Execute then
    shp_pozadi.Brush.Color:=cd_pozadi.Color;
end;

procedure TForm1.btn_clearClick(Sender: TObject);
begin
  PaintBox1.Canvas.Brush.Color:=clWhite;
  PaintBox1.Canvas.Brush.Style:=bsSolid;
  PaintBox1.Canvas.Pen.Style:=psClear;
  PaintBox1.Canvas.Rectangle(0,0,PaintBox1.Width, PaintBox1.Height);
  kliknuti:=0;
  konec:=false;
end;

end.
