unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ExtCtrls, StdCtrls, ExtDlgs, math;

type
  TForm1 = class(TForm)
    pnl_menu: TPanel;
    od_img: TOpenPictureDialog;
    btn_konec: TButton;
    btn_nacist: TButton;
    Image1: TImage;
    Image2: TImage;
    edt_uhel: TEdit;
    lbl_popis1: TLabel;
    btn_otoc: TButton;
    btn_vert: TButton;
    btn_hor: TButton;
    lbl_rozmery: TLabel;
    procedure btn_nacistClick(Sender: TObject);
    procedure btn_konecClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure btn_otocClick(Sender: TObject);
    procedure btn_vertClick(Sender: TObject);
    procedure btn_horClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

procedure TForm1.btn_nacistClick(Sender: TObject);
var nazev:string;
begin
  GetDir(0, nazev);
  od_img.InitialDir:=nazev;
  if od_img.Execute then
    begin
      Image1.Picture.LoadFromFile(od_img.FileName);
    end;

end;

procedure TForm1.btn_konecClick(Sender: TObject);
begin
  Application.Terminate;
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
  Image1.Canvas.Pen.Style:=psClear;
  Image1.Canvas.Brush.Style:=bsSolid;
  Image1.Canvas.Brush.Color:=clWhite;

  Image2.Canvas.Pen.Style:=psClear;
  Image2.Canvas.Brush.Style:=bsSolid;
  Image2.Canvas.Brush.Color:=clWhite;
end;

procedure TForm1.btn_otocClick(Sender: TObject);
var radek,vyska, x, y:integer;
    R,G,B:integer;
begin
//  Image2.Picture:=Image1.Picture;
  Image1.Canvas.Pen.Style:=psClear;
  Image1.Canvas.Pen.Color:=clWhite;
  Image1.Canvas.Brush.Style:=bsSolid;
  Image1.Canvas.Brush.Color:=clWhite;
  image2.Canvas.Rectangle(0,0,image2.Width,Image2.Height);

  for vyska:=0 to Image1.Picture.Height do
    begin
      for radek:=0 to Image1.Picture.Width do
        begin
          x:=round(vyska*cos(StrToInt(edt_uhel.Text)) - radek*sin(StrToInt(edt_uhel.Text)));
          y:=round(vyska*sin(StrToInt(edt_uhel.Text)) + radek*cos(StrToInt(edt_uhel.Text)));
          Image2.Canvas.Pixels[Image2.Picture.Width div 2 +x,Image2.Picture.Height div 2 +y] := Image1.Canvas.Pixels[radek,vyska];
        end;
    end;

  lbl_rozmery.Caption:='Puvodni: '+IntToStr(Image1.Picture.Width)+'x'+IntToStr(Image1.Picture.Height)+' Novy: '+IntToStr(Image2.Picture.Width-Image1.Picture.Height)+'x'+IntToStr(Image2.Picture.Height-Image1.Picture.Width);

  for vyska:=0 to Image1.Height +(Image1.Picture.Height div 2)do
    begin
      for radek:=0 to Image1.Picture.Width +(Image1.Picture.Width div 2) do
        begin
          if Image2.Canvas.Pixels[vyska,radek] = clWhite then
            begin
            if ((vyska > 2) AND (radek > 2) AND (radek < Image2.Width-2) AND (vyska < Image2.Height-2)) then
            begin
              R:=(GetRValue(Image2.Canvas.Pixels[radek-1,vyska])+GetRValue(Image2.Canvas.Pixels[radek+1,vyska])+GetRValue(Image2.Canvas.Pixels[radek,vyska+1])+GetRValue(Image2.Canvas.Pixels[radek,vyska-1])) div 4;
              G:=(GetGValue(Image2.Canvas.Pixels[radek-1,vyska])+GetGValue(Image2.Canvas.Pixels[radek+1,vyska])+GetGValue(Image2.Canvas.Pixels[radek,vyska+1])+GetGValue(Image2.Canvas.Pixels[radek,vyska-1])) div 4;
              B:=(GetBValue(Image2.Canvas.Pixels[radek-1,vyska])+GetBValue(Image2.Canvas.Pixels[radek+1,vyska])+GetBValue(Image2.Canvas.Pixels[radek,vyska+1])+GetBValue(Image2.Canvas.Pixels[radek,vyska-1])) div 4;
              if R>255 then R:=255;
              if G>255 then G:=255;
              if B>255 then B:=255;
              Image2.Canvas.Pixels[radek,vyska]:=RGB(R,G,B);
            end;
            end;
        end;
    end;

{
      for vyska:=0 to Image2.Height do
        begin
          for radek:=0 to Image2.Width-1 do
            begin
              R:=(GetRValue(Image2.Canvas.Pixels[radek,vyska])+GetRValue(Image2.Canvas.Pixels[radek+1,vyska])) div 2;
              G:=(GetRValue(Image2.Canvas.Pixels[radek,vyska])+GetRValue(Image2.Canvas.Pixels[radek+1,vyska])) mod 2;
              B:=(GetRValue(Image2.Canvas.Pixels[radek,vyska])+GetRValue(Image2.Canvas.Pixels[radek+1,vyska])) mod 2;
              Image2.Canvas.Pixels[radek,vyska] :=RGB(R,G,B);
            end;
        end;
}
{
  x:=Image2.Picture.Width-Image1.Picture.Width;
  y:=Image2.Picture.Height-Image2.Picture.height;
      for vyska:=0 to Image2.Picture.Height do
        begin
          for radek:=0 to Image2.Picture.Width do
            begin
              Image2.Canvas.Pixels[vyska+x,radek+y] := Image2.Canvas.Pixels[vyska,radek];
            end;
        end;
}        
end;

procedure TForm1.btn_vertClick(Sender: TObject);
var i,j:integer;
begin
  Image2.Picture:=Image1.Picture;
  for i:=0 to Image1.Picture.Width do
    begin
      for j:=0 to Image1.Picture.Height do
        begin
          Image2.Canvas.Pixels[i,Image1.Picture.Height-j]:=Image1.Canvas.Pixels[i,j];
        end;
    end;
end;

procedure TForm1.btn_horClick(Sender: TObject);
var i,j:integer;
begin
  Image2.Picture:=Image1.Picture;
  for i:=0 to Image1.Picture.Width do
    begin
      for j:=0 to Image1.Picture.Height do
        begin
          Image2.Canvas.Pixels[Image1.Picture.Width-i,j]:=Image1.Canvas.Pixels[i,j];
        end;
    end;
end;

end.
